#include <stdio.h>
#include <hal_resources_defines.h>
#include <libc_file_support.h>
#include <libc_mem_support.h>

#include <ToolkitSample.h>

#define SERDPM_CONN  1 /* SPI on X6 */

int main()
{
  #if SERDPM_CONN == 0 /* X5 */
    NX50_MMIO_SetCfg(0, MMIO_CONFIG_SPI1_MOSI, 0, 0);
    NX50_MMIO_SetCfg(1, MMIO_CONFIG_SPI1_MISO, 0, 0);
    NX50_MMIO_SetCfg(2, MMIO_CONFIG_SPI1_CLK,  0, 0);
    NX50_MMIO_SetCfg(3, MMIO_CONFIG_SPI1_CS0N, 0, 0);
    NX50_MMIO_SetCfg(4, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(6, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(5, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(7, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(29, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(31, MMIO_CONFIG_SPI1_CS0N, 0, 0);
  #elif SERDPM_CONN == 1 /* X6 */
    NX50_MMIO_SetCfg(0, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(1, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(2, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(3, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(4, MMIO_CONFIG_SPI1_MISO, 0, 0);
    NX50_MMIO_SetCfg(6, MMIO_CONFIG_SPI1_MOSI, 0, 0);
    NX50_MMIO_SetCfg(5, MMIO_CONFIG_SPI1_CLK,  0, 0);
    NX50_MMIO_SetCfg(7, MMIO_CONFIG_SPI1_CS0N, 0, 0);
    NX50_MMIO_SetCfg(29, MMIO_CONFIG_SPI1_CS0N, 0, 0);
    NX50_MMIO_SetCfg(31, MMIO_CONFIG_INPUT, 0, 0);
  #endif

  NX50_MMIO_SetCfg(34, MMIO_CONFIG_UART0_RXD, 0, 0);
  NX50_MMIO_SetCfg(35, MMIO_CONFIG_UART0_TXD, 0, 0);


  /* Libc memory initialiation */
  libc_mem_init();

  /* Init the libc part & redirect printf output to uart */
  libc_file_init();

  ToolkitSample();

  while (1);
}